package com.wecloud.im.tillo.app_ws.service;


import com.wecloud.im.tillo.app_ws.model.ResponseModel;
import com.wecloud.im.tillo.app_ws.model.request.ReceiveModel;
import io.geekidea.springbootplus.framework.common.api.ApiCode;

/**
 * @Description ws响应数据，各种状态码封装
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public interface WriteDataService {

    /**
     * 可自定义状态码 带data
     *
     * @param receiveModel
     * @param data
     */
    void dataAndStatus(ReceiveModel receiveModel, ApiCode apiCode, Object data, String toAppKey, String toClientId);

    /**
     * 固定"成功"状态码 带data
     *
     * @param requestModel
     * @param data
     */
    void successAndData(ReceiveModel requestModel, Object data, String toAppKey, String toClientId);

    /**
     * 固定"成功"状态码 无data
     *
     * @param requestModel
     */
    void nullDataSuccess(ReceiveModel requestModel, ApiCode apiCode, String toAppKey, String toClientId);

    /**
     * 固定"参数错误"状态码 无data
     *
     * @param requestModel
     */
    void paramErrorAndNullData(ReceiveModel requestModel, String toAppKey, String toClientId);

    /**
     * 调用ws处理响应逻辑
     *
     * @param responseModel
     */
    void write(ResponseModel responseModel, String toAppKey, String toClientId);


}
