package io.geekidea.springbootplus.framework.shiro.signature;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * shiro 用户签名认证
 * @Author luozh
 * @Date 2022年04月14日 16:43
 * @Version 1.0
 */
public class SignatureAuthFilter extends AuthenticatingFilter {

    private static final String AUTHORIZATION = "Authorization";

    @Override
    protected AuthenticationToken createToken(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {

        HttpServletRequest request =
                ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

        String token = request.getHeader(AUTHORIZATION);
        if (StringUtils.isBlank(token)) {
            throw new AuthenticationException("token不能为空");
        }


        return null;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        return false;
    }
}
