package com.sien.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.VipPrice;
import com.sien.common.mapper.VipPriceMapper;
import com.sien.common.param.VipPricePageParam;
import com.sien.common.service.VipPriceService;
import com.sien.common.vo.app.VipPriceQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员价格表 服务实现类
 *
 * @author xxx
 * @since 2021-03-11
 */
@Slf4j
@Service
public class VipPriceServiceImpl extends BaseServiceImpl<VipPriceMapper, VipPrice> implements VipPriceService {

    @Autowired
    private VipPriceMapper vipPriceMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveVipPrice(VipPrice vipPrice) throws Exception {
        return super.save(vipPrice);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateVipPrice(VipPrice vipPrice) throws Exception {
        return super.updateById(vipPrice);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteVipPrice(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public VipPriceQueryVo getVipPriceById(Long id) throws Exception {
        return vipPriceMapper.getVipPriceById(id);
    }

    @Override
    public Paging<VipPriceQueryVo> getVipPricePageList(VipPricePageParam vipPricePageParam) throws Exception {
        Page<VipPriceQueryVo> page = new PageInfo<>(vipPricePageParam, OrderItem.desc(getLambdaColumn(VipPrice::getCreateTime)));
        IPage<VipPriceQueryVo> iPage = vipPriceMapper.getVipPricePageList(page, vipPricePageParam);
        return new Paging<VipPriceQueryVo>(iPage);
    }

}
