package com.wecloud.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <pre>
 * 会话成员表 分页参数对象
 * </pre>
 *
 * @author wei
 * @date 2021-05-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ImConversationMembersListParam")
public class ListConversationMembersParam implements Serializable {

    private static final long serialVersionUID = -1445614972142934174L;

    @ApiModelProperty(value = "会话表id", required = true)
    private Long conversationId;

    @ApiModelProperty(value = "角色列表 可多选，不传则查全部", required = true)
    private List<Integer> roles;

    @ApiModelProperty(value = "clientId列表，传了则只查询指定入参群成员", required = true)
    private List<String> clientIds;

}
