package com.wecloud.im.executor;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import com.wecloud.im.ws.model.WsConstants;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 业务处理线程池
 */
public class BusinessThreadPool {

    private static final ThreadFactory BUSINESS_THREAD_FACTORY = new ThreadFactoryBuilder()
            .setNamePrefix("-business-").build();

    /**
     * 业务处理线程池
     */
    public static final ExecutorService BUSINESS_TASK_THREAD_POOL_EXECUTOR =
            new ThreadPoolExecutor(WsConstants.CPU_PROCESSORS, WsConstants.CPU_PROCESSORS * 2,
                    60L, TimeUnit.MILLISECONDS,
                    new LinkedBlockingQueue<Runnable>(1024 * 2), BUSINESS_THREAD_FACTORY, new ThreadPoolExecutor.CallerRunsPolicy());

}
