package com.wecloud.im.service;

import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.param.ImInboxPageParam;
import com.wecloud.im.param.ImInboxQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 消息收件箱表 服务类
 *
 * @author wei
 * @since 2021-05-06
 */
public interface ImInboxService extends BaseService<ImInbox> {

        /**
         * 保存
         *
         * @param imInbox
         * @return
         * @throws Exception
         */
        boolean saveImInbox(ImInbox imInbox) throws Exception;

        /**
         * 修改
         *
         * @param imInbox
         * @return
         * @throws Exception
         */
        boolean updateImInbox(ImInbox imInbox) throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteImInbox(Long id) throws Exception;

        /**
         * 根据ID获取查询对象
         *
         * @param id
         * @return
         * @throws Exception
         */
        ImInboxQueryVo getImInboxById(Long id) throws Exception;

        /**
         * 获取分页对象
         *
         * @param imInboxPageParam
         * @return
         * @throws Exception
         */
        Paging<ImInboxQueryVo> getImInboxPageList(ImInboxPageParam imInboxPageParam) throws Exception;

}
