package com.wecloud.im.service;

import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ImMessagePageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.wecloud.im.param.ImMessageQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 消息存储表 服务类
 *
 * @author wei
 * @since 2021-04-29
 */
public interface ImMessageService extends BaseService<ImMessage> {

        /**
         * 保存
         *
         * @param imMessage
         * @return
         * @throws Exception
         */
        boolean saveImMessage(ImMessage imMessage)throws Exception;

        /**
         * 修改
         *
         * @param imMessage
         * @return
         * @throws Exception
         */
        boolean updateImMessage(ImMessage imMessage)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteImMessage(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        ImMessageQueryVo getImMessageById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param imMessagePageParam
         * @return
         * @throws Exception
         */
        Paging<ImMessageQueryVo> getImMessagePageList(ImMessagePageParam imMessagePageParam) throws Exception;

        }
