package com.wecloud.im.biz.module.message.service.impl;

import lombok.extern.slf4j.Slf4j;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.wecloud.im.biz.module.message.entity.ImMultiRtcRoomMember;
import com.wecloud.im.biz.module.message.mapper.ImMultiRtcRoomMemberMapper;
import com.wecloud.im.biz.module.message.service.ImMultiRtcRoomMemberService;
import com.wecloud.im.core.common.service.impl.BaseServiceImpl;

/**
 * @Author wenzhida
 * @Date 2022/3/16 9:27
 * @Description 多人音视频房间成员服务接口实现
 */
@Slf4j
@Service
public class ImMultiRtcRoomMemberServiceImpl extends BaseServiceImpl<ImMultiRtcRoomMemberMapper, ImMultiRtcRoomMember> implements ImMultiRtcRoomMemberService {

    @Autowired
    private ImMultiRtcRoomMemberMapper imMultiRtcRoomMemberMapper;

    @Override
    public void changeRoomMemberState(Long fkClientId, String roomId, Integer state) {
        this.update(new UpdateWrapper<ImMultiRtcRoomMember>().lambda()
                .eq(ImMultiRtcRoomMember::getRoomId, roomId)
                .eq(ImMultiRtcRoomMember::getFkClientId, fkClientId)
                .set(ImMultiRtcRoomMember::getHeartbeatTime, new Date())
                .set(ImMultiRtcRoomMember::getState, state));
    }
}
