package com.wecloud.im.biz.module.message.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.wecloud.im.biz.core.rocketmq.component.MqSender;
import com.wecloud.im.biz.enums.EventResponseSubCmdEnum;
import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.entity.ImClient;
import com.wecloud.im.biz.module.message.param.FriendApplyEventDto;
import com.wecloud.im.biz.module.message.param.FriendApproveEventDto;
import com.wecloud.im.core.common.api.ApiCode;
import com.wecloud.im.core.common.api.ApiResult;
import com.wecloud.im.server.enums.WsResponseCmdEnum;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.im.server.model.request.PushVO;
import com.wecloud.im.server.sender.ChannelSender;
import com.wecloud.pushserver.client.model.constant.MqConstant;
import com.wecloud.pushserver.client.model.dto.PushDTO;

/**
 * @Description TODO
 * @Author lixiaozhong
 * @Date 2022/1/13 5:35 下午
 */
@Component
public class FriendEventSender {

    @Autowired
    private ChannelSender channelSender;

    @Autowired
    private ImApplicationService imApplicationService;

    @Autowired
    private MqSender mqSender;

    private final static String FRIEND_APPLY_TITLE = "好友申请";
    private final static String FRIEND_APPLY_TITLE_SUB = "您有好友申请待验证";
    private final static String FRIEND_APPROVE_TITLE = "好友验证结果";
    private final static String FRIEND_APPROVE_TITLE_AGREE = "您的好友同意了您的好友申请";
    private final static String FRIEND_APPROVE_TITLE_REJECT = "您的好友拒绝了您的好友申请";


    public void sendFriendApplyEventMsg(ImClient claimerClient, ImClient receiveClient, String requestRemark) {

        FriendApplyEventDto applyDto = new FriendApplyEventDto();
        applyDto.setSubCmd(EventResponseSubCmdEnum.FRIEND_APPLY.getCode());
        applyDto.setRequestRemark(requestRemark);
        applyDto.setClaimerClientId(claimerClient.getClientId());
        applyDto.setFriendClientId(receiveClient.getClientId());

        //  向接收方推送
        WsResponse<FriendApplyEventDto> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.NOTICE_EVENT_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(applyDto);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, receiveClient.getId());

        ImApplication app = imApplicationService.getCacheById(receiveClient.getFkAppid());

        PushVO pushVO = new PushVO();
        pushVO.setTitle(FRIEND_APPLY_TITLE);
        pushVO.setSubTitle(FRIEND_APPLY_TITLE_SUB);
        PushDTO pushDTO = mqSender.buildPushDto(pushVO, receiveClient, app);
        if (pushDTO != null) {
            mqSender.orderSend(MqConstant.Topic.IM_ORDER_MSG_TOPIC, MqConstant.Tag.IM_ORDER_MSG_TAG, pushDTO);
        }
    }

    public void sendFriendApproveEventMsg(ImClient claimerClient, ImClient receiveClient, boolean isAgree, String rejectRemark) {
        FriendApproveEventDto approveDto = new FriendApproveEventDto();
        approveDto.setSubCmd(EventResponseSubCmdEnum.FRIEND_APPROVE.getCode());
        approveDto.setAgree(isAgree);
        approveDto.setRejectRemark(rejectRemark);
        approveDto.setClaimerClientId(claimerClient.getClientId());
        approveDto.setFriendClientId(receiveClient.getClientId());

        //  向接收方推送
        WsResponse<FriendApproveEventDto> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.NOTICE_EVENT_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(approveDto);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, receiveClient.getId());

        ImApplication app = imApplicationService.getCacheById(receiveClient.getFkAppid());

        PushVO pushVO = new PushVO();
        pushVO.setTitle(FRIEND_APPROVE_TITLE);
        pushVO.setSubTitle(isAgree ? FRIEND_APPROVE_TITLE_AGREE : FRIEND_APPROVE_TITLE_REJECT);
        PushDTO pushDTO = mqSender.buildPushDto(pushVO, receiveClient, app);
        if (pushDTO != null) {
            mqSender.orderSend(MqConstant.Topic.IM_ORDER_MSG_TOPIC, MqConstant.Tag.IM_ORDER_MSG_TAG, pushDTO);
        }
    }
}
