package com.wecloud.im.biz.module.message.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.biz.module.message.controller.param.rtc.SingleRtcRecordParam;
import com.wecloud.im.biz.module.message.entity.ImRtcRecord;
import com.wecloud.im.biz.module.message.service.ImRtcRecordService;
import com.wecloud.im.core.common.api.ApiResult;
import com.wecloud.im.core.common.controller.BaseController;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
@Slf4j
@RestController
@RequestMapping("/rtcRecord")
@Api(value = "通话记录控制器")
public class ImRtcRecordController extends BaseController {

    @Autowired
    private ImRtcRecordService rtcRecordService;

    @PostMapping("/listRtcRecords")
    @ApiOperation(value = "分页获取通话记录")
    public ApiResult<Page<ImRtcRecord>> listRtcRecords(@RequestBody SingleRtcRecordParam singleRtcRecordParam) {
        log.info("分页获取通话记录入参 {}", JSON.toJSONString(singleRtcRecordParam));
        return ApiResult.ok(rtcRecordService.getPageImRtcRecords(singleRtcRecordParam));
    }

}
