package com.wecloud.im.biz.enums;

import com.wecloud.im.core.common.enums.BaseEnum;

/**
 * @Author Future
 * @Date 2022/5/22 23:42
 * @Description 单人音视频状态枚举
 */
public enum RtcStateEnum implements BaseEnum {

    /**
     * 1 - 音视频发起
     */
    CREATED(1, "音视频发起"),

    /**
     * 2 - 音视频中
     */
    ING(2, "音视频中"),

    /**
     * 3 - 音视频结束
     */
    END(3, "音视频结束");

    RtcStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
