package com.wecloud.im.biz.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.biz.enums.CallTypeEnum;
import com.wecloud.im.biz.module.message.controller.param.rtc.CandidateForwardParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.CreateRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.CreateRtcChannelResult;
import com.wecloud.im.biz.module.message.controller.param.rtc.JoinRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.LeaveRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.RejectRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.SdpForwardParam;
import com.wecloud.im.biz.module.rtc.service.RtcService;
import com.wecloud.im.core.common.api.ApiCode;
import com.wecloud.im.core.common.enums.BaseEnum;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.netty.dispatch.annotation.ActionMapping;

@Slf4j
@Component
@ActionMapping(value = "/im/rtc")
@Api(value = "ws-音视频通话", tags = {"ws-音视频通话"})
public class RtcAction {

    @Autowired
    private RtcService rtcService;

    /**
     * 创建频道,并邀请客户端加入
     */
    @ActionMapping("/createAndCall")
    @ApiOperation(value = "创建频道,并邀请客户端加入", notes = "创建频道,并邀请客户端加入")
    public WsResponse<CreateRtcChannelResult> createAndCall(CreateRtcChannelParam data) {
        log.info("音频通话，创建频道并邀请客户端加入，入参 {}", JSON.toJSONString(data));
        if (BaseEnum.valueOf(CallTypeEnum.class, data.getCallType()) == null) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return WsResponse.ok(rtcService.createAndCall(data));
    }


    @ActionMapping("/join")
    @ApiOperation(value = "同意进入频道", notes = "")
    public WsResponse<Map<String, Boolean>> join(JoinRtcChannelParam data) {
        log.info("音频通话，同意进入频道，入参 {}", JSON.toJSONString(data));
        rtcService.join(data);
        return WsResponse.ok();
    }

    @ActionMapping("/reject")
    @ApiOperation(value = "拒接进入频道", notes = "")
    public WsResponse<Map<String, Boolean>> reject(RejectRtcChannelParam data) {
        log.info("音频通话，拒接进入频道，入参 {}", JSON.toJSONString(data));
        rtcService.reject(data);
        return WsResponse.ok();
    }

    @ActionMapping("/leave")
    @ApiOperation(value = "主动挂断(离开频道)", notes = "")
    public WsResponse<Map<String, Boolean>> leave(LeaveRtcChannelParam data) {
        log.info("音频通话，主动挂断(离开频道)，入参 {}", JSON.toJSONString(data));
        rtcService.leave(data);
        return WsResponse.ok();
    }

    @ActionMapping("/sdpForward")
    @ApiOperation(value = "SDP数据转发", notes = "")
    public WsResponse<Map<String, Boolean>> sdpForward(SdpForwardParam data) {
        log.info("音频通话，SDP数据转发，入参 {}", JSON.toJSONString(data));
        rtcService.sdpForward(data);
        return WsResponse.ok();
    }

    @ActionMapping("/candidateForward")
    @ApiOperation(value = "candidate候选者数据转发", notes = "")
    public WsResponse<Map<String, Boolean>> candidateForward(CandidateForwardParam data) {
        log.info("音频通话，candidate候选者数据转发，入参 {}", JSON.toJSONString(data));
        rtcService.candidateForward(data);
        return WsResponse.ok();
    }
}
