package com.wecloud.im.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/21 18:15
 * @Description 用户登录入参
 */
@Data
public class UserLoginParam implements Serializable {

    private static final long serialVersionUID = 9182337935301787778L;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 密码
     */
    @NotNull(message = "密码不可为空")
    @ApiModelProperty("密码")
    private String password;

    @NotNull(message = "appKey不可为空")
    @ApiModelProperty("appKey")
    private String appKey;

    /**
     * 客户端平台
     * @see com.wecloud.im.enums.PlatformEnum
     */
    @NotNull(message = "平台不可为空")
    @ApiModelProperty("客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs")
    private Integer platform;

    @ApiModelProperty("设备推送token")
    private String deviceToken;
}
