package com.wecloud.rtc;

import java.io.Serializable;

public class SubCmd implements Serializable {

    /**
     * subCmd子类型指令码
     */
    public static final String SUB_CMD = "subCmd";

    /**
     * 创建频道
     */
    public static final String CREATE = "create";

    /**
     * 加入频道
     */
    public static final String JOIN = "join";

    /**
     * 拒绝加入频道
     */
    public static final String REJECT = "reject";

    /**
     * 主动挂断(离开频道)
     */
    public static final String LEAVE = "leave";


    // --- 服务端响应

    /**
     * 接收到RTC邀请
     */
    public static final String RTC_CALL = "rtcCall";

    /**
     * 用户状态更新事件(用户加入,用户退出,用户拒接邀请)
     */
    public static final String CLIENT_EVENT = "clientEvent";

    /**
     * 流状态更新(切换音频 切换视频)
     */
    public static final String TYPE_EVENT = "typeEvent";

    /**
     * 状态更新(网络断开,挂断)
     */
    public static final String STATUS_EVENT = "statusEvent";

    /**
     * SDP数据转发
     */
    public static final String SDP = "SDP";

    /**
     * 忙线
     */
    public static final String BUSY = "busy";


}
