package com.wecloud.im.controller;

import com.wecloud.im.param.CreateRtcChannelResult;
import com.wecloud.im.param.add.CreateRtcChannelParam;
import com.wecloud.rtc.service.RtcService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 音视频通话 控制器
 *
 * @author wei
 * @since 2021-10-18
 */
@Slf4j
@RestController
@RequestMapping("/rtc")
@Api(value = "音视频通话", tags = {"音视频通话"})
public class ImRtcController extends BaseController {

    @Autowired
    private RtcService rtcService;

    /**
     * 创建频道,并邀请客户端加入
     */
    @PostMapping("/createAndCall")
    @ApiOperation(value = "创建频道,并邀请客户端加入", notes = "创建频道,并邀请客户端加入")
    public ApiResult<CreateRtcChannelResult> createAndCall(@RequestBody CreateRtcChannelParam createRtcChannelParam) throws Exception {
        CreateRtcChannelResult createRtcChannelResult = rtcService.create(createRtcChannelParam);
        return ApiResult.ok(createRtcChannelResult);
    }


    public ApiResult<Boolean> join() {
        return ApiResult.result(true);

    }


    public ApiResult<Boolean> reject() {
        return ApiResult.result(true);

    }


    public ApiResult<Boolean> leave() {
        return ApiResult.result(true);

    }


    public ApiResult<Boolean> sdpForword() {
        return ApiResult.result(true);

    }


    public ApiResult<Boolean> candidateForword() {
        return ApiResult.result(true);

    }

}

