package com.jumeirah.api.app.controller;

import com.jumeirah.api.app.entity.param.FeedbackAddParam;
import com.jumeirah.common.entity.Feedback;
import com.jumeirah.common.service.FeedbackService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 意见反馈 控制器
 *
 * @author giao
 * @since 2020-10-26
 */
@Slf4j
@RestController
@RequestMapping("/app/feedback")
@Api(value = "意见反馈API", tags = {"意见反馈"})
public class FeedbackController extends BaseController {

    @Autowired
    private FeedbackService feedbackService;

    /**
     * 添加意见反馈
     */
    @PostMapping("/add")
    @OperationLog(name = "添加意见反馈", type = OperationLogType.ADD)
    @ApiOperation(value = "添加意见反馈")
    public ApiResult<Boolean> addFeedback(@Validated(Add.class) @RequestBody FeedbackAddParam feedbackAddParam) throws Exception {

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        Feedback feedback = new Feedback();
        feedback.setUserId(jwtToken.getUserId());
        feedback.setContent(feedbackAddParam.getContent());

        boolean flag = feedbackService.saveFeedback(feedback);
        return ApiResult.result(flag);
    }
//
//    /**
//     * 修改意见反馈
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改意见反馈", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改意见反馈")
//    public ApiResult<Boolean> updateFeedback(@Validated(Update.class) @RequestBody Feedback feedback) throws Exception {
//        boolean flag = feedbackService.updateFeedback(feedback);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除意见反馈
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除意见反馈", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除意见反馈")
//    public ApiResult<Boolean> deleteFeedback(@PathVariable("id") Long id) throws Exception {
//        boolean flag = feedbackService.deleteFeedback(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取意见反馈详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "意见反馈详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "意见反馈详情")
//    public ApiResult<FeedbackQueryVo> getFeedback(@PathVariable("id") Long id) throws Exception {
//        FeedbackQueryVo feedbackQueryVo = feedbackService.getFeedbackById(id);
//        return ApiResult.ok(feedbackQueryVo);
//    }
//
//    /**
//     * 意见反馈分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "意见反馈分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "意见反馈分页列表")
//    public ApiResult<Paging<FeedbackQueryVo>> getFeedbackPageList(@Validated @RequestBody FeedbackPageParam feedbackPageParam) throws Exception {
//        Paging<FeedbackQueryVo> paging = feedbackService.getFeedbackPageList(feedbackPageParam);
//        return ApiResult.ok(paging);
//    }

}

