package com.wecloud.im.sdk;

import lombok.experimental.UtilityClass;

/**
 * 资源常量类
 * @Author luozh
 * @Date 2022年04月18日 13:34
 * @Version 1.0
 */
@UtilityClass
public class ResourcePathConstants {

    /**
     * 注册客户端
     */
    public static final String REGISTER_CLIENT_URL = "/api/imClient/registerClient";

    /**
     * 获取token
     */
    public static final String GET_TOKEN_URL = "/api/token/getToken";

    /**
     * 修改用户
     */
    public static final String MODIFY_USER_URL = "/api/imClient/updateHeadAndNickname";

    /**
     * 获取用户拓展参数
     */
    public static final String GET_USER_ATTRIBUTES_REQUEST = "/api/imClient/getUserAttributes";

    /**
     * 更新用户拓展参数
     */
    public static final String MODIFY_USER_ATTRIBUTES_REQUEST = "/api/imClient/modifyUserAttributes";

    /**
     * 获取好友申请列表
     */
    public static final String GET_UNSURE_FRIENDS = "/api/friend/sdk/unsureFriends";

    /**
     * 全量获取好友列表
     */
    public static final String GET_FRIENDS = "/api/friend/sdk/getFriends";

    /**
     * 群设置
     */
    public static final String CHAT_SETTING = "/api/imConversationMembers/chatSetting";

    /**
     * 好友请求
     */
    public static final String FRIEND_REQUEST = "/api/friend/sdk/apply";

    /**
     * 分页获取黑名单列表请求
     */
    public static final String PAGE_BLACKLIST_REQUEST = "/api/ClientBlacklist/sdk/pageBlacklist";

    /**
     * 群成员互加好友
     */
    public static final String GROUP_MEMBERS_FRIEND_REQUEST = "/api/imConversationMembers/addUser";

    /**
     * 获取聊天室成员
     */
    public static final String LIST_CHAT_ROOM_MEMBER_REQUEST = "/api/conversation/listChatRoomMember";

    /**
     * 批量获取会话信息
     */
    public static final String LIST_CONVERSATION_REQUEST = "/api/conversation/listConversation";

    /**
     * 发布群消息
     */
    public static final String PUBLISH_GROUP_CHAT_MESSAGE_REQUEST = "/api/imMessage/group/publish";

    /**
     * 发布群状态消息
     */
    public static final String PUBLISH_GROUP_CHAT_STATUS_MESSAGE_REQUEST = "/api/imMessage/group/status/publish";

    /**
     * 发布群消息
     */
    public static final String PUBLISH_PRIVATE_CHAT_MESSAGE_REQUEST = "/api/imMessage/private/publish";

    /**
     * 发布群状态消息
     */
    public static final String PUBLISH_PRIVATE_CHAT_STATUS_MESSAGE_REQUEST = "/api/imMessage/private/status/publish";

    /**
     * 创建群
     */
    public static final String CREATE_GROUP_REQUEST = "/api/group/createGroup";

    /**
     * 解散群
     */
    public static final String DISMISS_GROUP_REQUEST = "/api/group/dismissGroup";

    /**
     * 加入群
     */
    public static final String JOIN_GROUP_REQUEST = "/api/group/joinGroup";

    /**
     * 离开群
     */
    public static final String LEAVE_GROUP_REQUEST = "/api/group/leaveGroup";

    /**
     * 获取群成员列表
     */
    public static final String LIST_GROUP_MEMBERS_REQUEST = "/api/group/listGroupMembers";

    /**
     * 群设置请求
     */
    public static final String GROUP_SETTING_REQUEST = "/api/conversation/groupChatSettingForSdk";

    /**
     * 用户关系请求
     */
    public static final String USER_RELATION_REQUEST = "/api/imClient/getClientRelation";

    /**
     * 封禁用户
     */
    public static final String BANNED_USER_REQUEST = "/api/imClient/bannedUser";

    /**
     * 删除好友请求
     */
    public static final String UNFRIEND_REQUEST = "/api/friend/sdk/unfriends";

    /**
     * 好友备注请求
     */
    public static final String REMARK_FRIEND_REQUEST = "/api/friend/sdk/remark";

    /**
     * 禁言群成员
     */
    public static final String MUTED_GROUP_MEMBER_REQUEST = "/api/group/mutedMembers";

    /**
     * 更换群主 请求
     */
    public static final String GROUP_OWNER_TRANSFER_REQUEST = "/api/group/groupOwnerTransfer";

    /**
     * 添加群管理员 请求
     */
    public static final String ADD_GROUP_ADMIN_REQUEST = "/api/group/addGroupAdmin";

    /**
     * 移除群管理员 请求
     */
    public static final String REMOVE_GROUP_ADMIN_REQUEST = "/api/group/removeGroupAdmin";

}
