package com.jumeirah.common.service;

import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.param.StrokePageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.vo.StrokeQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 行程表 服务类
 *
 * @author wei
 * @since 2020-09-29
 */
public interface StrokeService extends BaseService<Stroke> {

        /**
         * 保存
         *
         * @param stroke
         * @return
         * @throws Exception
         */
        boolean saveStroke(Stroke stroke)throws Exception;

        /**
         * 修改
         *
         * @param stroke
         * @return
         * @throws Exception
         */
        boolean updateStroke(Stroke stroke)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteStroke(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        StrokeQueryVo getStrokeById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param strokePageParam
         * @return
         * @throws Exception
         */
        Paging<StrokeQueryVo> getStrokePageList(StrokePageParam strokePageParam) throws Exception;

        }
