package com.wecloud.netty.dispatch.general.config;

import com.wecloud.netty.dispatch.ActionContext;
import com.wecloud.netty.dispatch.ActionDispatcher;
import com.wecloud.netty.dispatch.config.ActionConfigurer;
import com.wecloud.netty.dispatch.extend.ActionBox;
import com.wecloud.netty.dispatch.general.impl.GeneralActionInterceptor;

/**
 * @author lixiaozhong
 */
public class GeneralActionDispatcher extends ActionDispatcher {

	private GeneralActionDefaultConfigurer handlerActionConfigurer = new GeneralActionDefaultConfigurer();
	private GeneralActionInterceptor handlerActionInterceptor = new GeneralActionInterceptor();

	public GeneralActionDispatcher() {
		this.initialize();
	}

	public GeneralActionDispatcher(ActionBox actionBox) {
		this.initialize();
		this.add(actionBox);
	}

	public GeneralActionDispatcher(ActionBox actionBox, String... actionLocations) {
		this.initialize();
		this.add(actionBox);
		this.scan(actionLocations);
	}

	@Override
	public void addConfig(ActionConfigurer actionConfigurer) {
		super.addConfig(actionConfigurer);
	}

	private void initialize() {
		this.addConfig(handlerActionConfigurer);
		this.addConfig(new GeneralActionConfigurerAdapter() {
			@Override
			public void addConfig(ActionContext actionContext) {
				actionContext.getActionInterceptorRegistry().add(handlerActionInterceptor);
			}
		});
	}

	public void add(ActionBox actionBox) {
		// "com.*.action"
		this.addConfig(new GeneralActionConfigurerAdapter() {
			@Override
			public void addConfig(ActionContext actionContext) {
				actionContext.getActionBoxRegistry().add(actionBox);
			}
		});
	}
}
