package com.wecloud.im.biz.module.rtc.service;

import com.wecloud.im.biz.module.rtc.entity.response.RtcCallResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcCandidateForwardResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcClientJoinResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcClientLeaveResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcClientRejectResponse;
import com.wecloud.im.biz.module.rtc.entity.response.RtcSdpForwardResponse;

/**
 * WebRtc webSocket下发指令数据
 */
public interface WsRtcWrite {

    /**
     * 接收到RTC邀请
     */
    void rtcCall(RtcCallResponse rtcCallResponse, Long toClientId);

    /**
     * 用户状态更新事件(用户加入频道)
     */
    void clientJoin(RtcClientJoinResponse rtcClientJoinResponse, Long toClientId);

    /**
     * 用户状态更新事件(用户退出频道)
     */
    void clientLeave(RtcClientLeaveResponse rtcClientLeaveResponse, Long toClientId);

    /**
     * 用户状态更新事件(用户拒接邀请;不同意进入频道)
     */
    void clientReject(RtcClientRejectResponse rtcClientRejectResponse, Long toClientId);

    /**
     * SDP数据转发
     */
    void sdpForward(RtcSdpForwardResponse rtcSdpForwardResponse, Long toClientId);

    /**
     * candidate候选者数据转发
     */
    void candidateForward(RtcCandidateForwardResponse rtcCandidateForwardResponse, Long toClientId);

}
