package com.wecloud.im.biz.module.rtc.service;

import com.wecloud.im.biz.module.message.controller.param.rtc.CandidateForwardParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.CreateRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.CreateRtcChannelResult;
import com.wecloud.im.biz.module.message.controller.param.rtc.JoinRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.LeaveRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.RejectRtcChannelParam;
import com.wecloud.im.biz.module.message.controller.param.rtc.SdpForwardParam;

/**
 * 管理rtc频道
 */
public interface RtcService {

    /**
     * 创建一个频道,并向接收方发送系统推送
     */
    CreateRtcChannelResult createAndCall(CreateRtcChannelParam createRtcChannelParam);

    /**
     * 加入频道
     */
    Boolean join(JoinRtcChannelParam joinRtcChannelParam);

    /**
     * 拒接加入频道
     */
    Boolean reject(RejectRtcChannelParam rejectRtcChannelParam);

    /**
     * 退出频道
     */
    Boolean leave(LeaveRtcChannelParam leaveRtcChannelParam);

    /**
     * SDP数据转发
     *
     * @param sdpForwardParam
     * @return
     */
    Boolean sdpForward(SdpForwardParam sdpForwardParam);

    /**
     * candidate候选者数据转发
     *
     * @param candidateForwardParam
     * @return
     */
    Boolean candidateForward(CandidateForwardParam candidateForwardParam);

    /**
     * 异常断线判断处理
     */
    void abnormalDisconnect();

}
