package com.wecloud.im.biz.module.message.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.wecloud.can.core.base.entity.BaseEntity;
import com.wecloud.im.biz.enums.MultiRtcMemberStateEnum;

/**
 * @Author wenzhida
 * @Date 2022/3/15 23:09
 * @Description 多人音视频房间成员
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "多人音视频房间成员")
public class ImMultiRtcRoomMember extends BaseEntity {

    private static final long serialVersionUID = -3806432271911087255L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("房间id")
    private String roomId;

    @ApiModelProperty("im房间id")
    private Long fkRtcRoomId;

    @ApiModelProperty("client主键id")
    private Long fkClientId;

    @ApiModelProperty("客户端id")
    private String clientId;

    /**
     * 多人音视频房间成员状态枚举
     * @see MultiRtcMemberStateEnum
     */
    @ApiModelProperty("房间成员状态，1：呼叫中，2：已接听，3：已拒绝，4：未接听，5：已断开")
    private Integer state;

    @ApiModelProperty("呼叫时间")
    private Date callTime;

    @ApiModelProperty("心跳时间")
    private Date heartbeatTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
