package com.wecloud.im.biz.module.message.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.wecloud.can.core.base.entity.BaseEntity;

/**
 * apns配置表
 *
 * @author wei
 * @since 2021-09-18
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImIosApns对象")
public class ImIosApns extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空")
    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppId;

    @ApiModelProperty("Base64(apns.p12)")
    private String apnsFileValue;

    @ApiModelProperty("环境,正式1,测试0")
    private Integer env;

    @ApiModelProperty("bundle_id")
    private String bundleId;

    @ApiModelProperty("证书密码")
    private String pwd;

}
