package com.wecloud.im.biz.module.message.controller.param.add;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.wecloud.can.core.base.entity.BaseEntity;

/**
 * 第三方应用表
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImApplicationAdd")
public class ImApplicationAdd extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

//    @ApiModelProperty("key")
//    private String appKey;
//
//    @ApiModelProperty("密钥")
//    private String appSecret;

    @ApiModelProperty("app名称")
    private String appName;

    @ApiModelProperty("ios推送通道,友盟:1;firebase:2; apns原生:3")
    private Integer iosPushChannel;

    @ApiModelProperty("安卓推送通道,友盟:1;firebase:2; 信鸽3")
    private Integer androidPushChannel;

    @ApiModelProperty("友盟推送key")
    private String umengKey;

    @ApiModelProperty("友盟推送密钥")
    private String umengSecret;

    @ApiModelProperty("firebase推送密钥")
    private String firebaseSecret;

    private String adminPwd;

}
