package com.wecloud.im.biz.externalaccess.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.hutool.crypto.digest.MD5;

import com.wecloud.can.core.base.controller.BaseController;
import com.wecloud.can.core.util.ApiResult;
import com.wecloud.im.biz.externalaccess.param.MultiMeetSignGetParam;

/**
 * @Author wenzhida
 * @Date 2022/3/3 17:39
 * @Description 多人音视频控制器
 */
@Slf4j
@RestController
@RequestMapping("/multiMeet")
@Api(value = "多人音视频API", tags = {"多人音视频"})
public class MultiMeetController extends BaseController {

    /**
     * 获取sign
     */
    @PostMapping("/getSign")
    @ApiOperation(value = "获取多人音视频专用sign")
    public ApiResult<String> sendVerifyCode(@RequestBody @Validated MultiMeetSignGetParam param) {
        String sign = new MD5().digestHex(param.getTimestamp() + param.getClientId()
                + param.getAppKey() + param.getAppSecret() + param.getPlatform());
        return ApiResult.ok(sign);
    }


}

