package com.wecloud.im.biz.enums;

import com.wecloud.can.core.base.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/23 13:44
 * @Description 性别枚举
 */
public enum SexEnum implements BaseEnum {

    /**
     * 1 - 男
     */
    MAN(1, "男"),

    /**
     * 2 - 女
     */
    WOMAN(2, "女"),

    /**
     * 3 - 未知
     */
    UNKNOWN(3, "未知");

    SexEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
