package com.wecloud.im.user.param;

import com.wecloud.im.friend.param.ImFriendBaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/22 23:20
 * @Description 好友出参
 */
@Data
public class FriendDto extends ImFriendBaseDto {

    private static final long serialVersionUID = 5580006330057637138L;

    @ApiModelProperty("蓝豆号")
    private String idNumber;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("好友拒绝原因")
    private String rejectRemark;

    @ApiModelProperty("好友请求说明")
    private String requestRemark;

    /**
     * 头像路径url
     */
    @ApiModelProperty("头像路径url")
    private String headPortrait;
    
}
