package com.wecloud.im.ws.service;

import com.wecloud.im.ws.model.ClientInfo;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Description 管理netty用户channel对象
 * @Author hewei hwei1233@163.com
 * @Date 2019-08-01
 */
public interface MangerChannelService {

    /**
     * channel对象
     * 用户id为key
     * context为值
     */
    Map<String, NioSocketChannel> CHANNEL_MAP = new ConcurrentHashMap<>();

    /**
     * 本地维护 uid 对应 channel_shortID
     */
    Map<String, Set<String>> CLIENTS_MAP = new ConcurrentHashMap<>();

    /**
     * channel_shortID对应client端数据
     */
    Map<String, ClientInfo> SESSION_INFO_MAP = new ConcurrentHashMap<>();

    /**
     * CLIENT_ID,是客户端的字符串id
     */
    AttributeKey<String> CLIENT_ID = AttributeKey.valueOf("ci");

    /**
     * 是app的字符串id
     */
    AttributeKey<String> APP_KEY = AttributeKey.valueOf("ak");

    /**
     * LANGUAGE
     */
    AttributeKey<String> LANGUAGE = AttributeKey.valueOf("la");

    /**
     * APP_VERSION
     */
    AttributeKey<String> APP_VERSION = AttributeKey.valueOf("av");
    AttributeKey<String> TOKEN = AttributeKey.valueOf("to");
    AttributeKey<String> DEVICEID = AttributeKey.valueOf("dc");
    AttributeKey<String> PLATFORM = AttributeKey.valueOf("pt");
    AttributeKey<Integer> READ_IDLE_TIMES = AttributeKey.valueOf("readIdleTimes");


    /**
     * 根据userID获取channel
     *
     * @return
     */
    NioSocketChannel get(String appKey, String clientId);

    /**
     * userID绑定channel
     *
     * @param channel
     */
    void put(String appKey, String clientId, NioSocketChannel channel);

    /**
     * 移除channel
     * @param channelHandlerContext
     */
    void remove(ChannelHandlerContext channelHandlerContext);

    /**
     * 根据channel返回客户端key和id
     *
     * @param channelHandlerContext
     * @return
     */
    String getInfoByChannel(ChannelHandlerContext channelHandlerContext);

    /**
     * 下发数据
     *
     * @param msg
     * @param userId
     * @return
     */
//    boolean writeData(String msg, Long userId);


    /**
     * 获取用户在线状态
     *
     * @param toAppKey
     * @param toClientId
     * @return true:在线, false 不在线
     */
    boolean getOnlineStatus(String toAppKey, String toClientId);

    /**
     * 下发数据
     *
     * @param msg
     * @return
     */
    boolean writeData(String msg, String toAppKey, String toClientId);

//    /**
//     * rpc异步下发数据
//     *
//     * @param msg
//     * @param userId
//     * @return
//     */
//    boolean rpcWriteData(String msg, Long userId);
//
//    /**
//     * rpc-异步下发踢人数据及关闭旧通道
//     *
//     * @param msg
//     * @param userId
//     * @return
//     */
//    boolean rpcKickWriteData(String msg, Long userId);
//
//    /**
//     * rpc-异步关闭旧通道
//     *
//     * @param userId
//     * @return
//     */
//    boolean rpcCloseOldChannel(Long userId);
//
//    Boolean isOnLocal(Long userId);

}
