package com.wecloud.im.ws.cache;

import com.wecloud.im.ws.utils.InitIp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author hewei123@163.com
 * @Description 用户与redis绑定
 * @createTime 2020年04月14日 16:21:00
 */
@Service
@Slf4j
public class UserCache {


//    /**
//     * 在线状态
//     */
//    public static final Integer ONLINE = 1;
//    /**
//     * 离线状态
//     */
//    public static final Integer OFFLINE = 0;

    /**
     * key name
     * websocket user  info
     */
    private static final String KEY_BASE = "wui:";

//    /**
//     * 用户在线状态fieldKey
//     */
//    private static final String ONLINE_STATUS_KEY = "ost";

    /**
     * 用户所连机器ip的fieldKey
     */
    private static final String LAN_IP = "lip";


    /**
     * 用户公网ip，在公网部署集群需要用到
     */
    private static final String PUBLIC_IP = "pip";
    private static final String type = "ty";
    private static final String deviceToken = "dt";


    /**
     * 用户上线绑定机器ip
     *
     * @param id
     */
    public void online(String id) {
        log.info("ws用户上线保存redis连接ip:" + InitIp.lAN_IP, ",uid:");
//        redisUtils.hset(KEY_BASE + id, PRIVATE_IP_KEY, lAN_IP);
//        redisUtils.hset(KEY_BASE + id, ONLINE_STATUS_KEY, String.valueOf(ONLINE));
    }

    /**
     * 用户下线删除绑定机器ip
     *
     * @param id
     */
    public void offline(String id) {
        log.info("ws用户离线删除redis key,uid:" + id);

//        redisUtils.kdel(KEY_BASE + id);
    }

//    /**
//     * 根据用户id获取存在redis中的数据 例如绑定的服务器ip地址
//     *
//     * @param id
//     * @return
//     */
//    public AppHashValueModel getById(String id) {
//
//        Map<String, String> hgetll = redisUtils.hgetll(KEY_BASE + id);
//        if (hgetll.isEmpty()) {
//            return null;
//        }
//        AppHashValueModel appHashValueModel = new AppHashValueModel();
//        appHashValueModel.setLanIp(hgetll.get(PRIVATE_IP_KEY));
//        appHashValueModel.setOnlineStatus(Integer.parseInt(hgetll.get(ONLINE_STATUS_KEY)));
//        return appHashValueModel;
//
//    }
//

}
