package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.mapper.ImInboxMapper;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImInboxService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 消息收件箱表 服务实现类
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@Service
public class ImInboxServiceImpl extends BaseServiceImpl<ImInboxMapper, ImInbox> implements ImInboxService {

    @Autowired
    private ImInboxMapper imInboxMapper;
    @Autowired
    private ImClientService imClientService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateImMsgReceived(ImMsgReceivedStatusUpdate imMsgReceivedUpdate) {
        // 不做接收事件处理
        return true;
    }

    /**
     * 统计未读消息数量
     *
     * @param clientId
     * @return
     */
    @Override
    public Integer countMyNotReadCount(Long clientId) {
        return imInboxMapper.countMyNotReadCount(clientId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateImMsgRead(MsgReadStatusUpdateParam msgReadStatusUpdateParam) {
        // 小虎豆不做单条消息修改已读
        return true;

    }

    @Override
    public Boolean updateMsgReadStatusByConversation(UpdateMsgReadStatusByConversationParam param) {
        ImClient currentClient = imClientService.getCurrentClient();
        this.remove(new QueryWrapper<ImInbox>().lambda()
                .eq(ImInbox::getFkConversationId, param.getConversationId())
                .le(ImInbox::getFkMsgId, param.getMsgIdEnd())
                .eq(ImInbox::getReceiver, currentClient.getId()));
        return true;
    }


}
