package com.wecloud.im.service;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;


/**
 * @Author Future
 * @Date 2022/8/24 17:18
 * @Description 本地缓存服务
 */
@Slf4j
@Service
public class EhcacheService {

    @Autowired
    private CacheManager cacheManager;

    /**
     * 本地缓存中获取
     * @param key
     * @return
     */
    public Boolean getIsPush(String key) {
        Cache cache = cacheManager.getCache("push");
        Object value = cache.get(key);
        log.info("ehcache {}", JSON.toJSONString(value));
        if (value != null) {
            return false;
        } else {
            cache.put(key, 1);
            return true;
        }
    }


}
