package com.wecloud.im.sdk.model.message;

import lombok.Getter;
import lombok.Setter;

import com.wecloud.im.sdk.enums.MessageTypeEnum;

/**
 *
 * @Author luozh
 * @Date 2022年05月07日 13:51
 * @Version 1.0
 */
@Getter
public class BaseMessage {

    /**
     * 类型
     */
    private Integer type;

    /**
     * 用来给开发者存储拓展的自定义属性字段
     */
    @Setter
    private Object attrs;

    public BaseMessage(MessageTypeEnum type) {
        this.setType(type);
    }

    /**
     * 设置类型
     * @Author luozh
     * @Date 2022年05月07日 01:55:06
     * @param type
     * @Return
     */
    protected void setType(MessageTypeEnum type) {
        this.type = type.getCode();
    }
}
