package com.wecloud.dispatch.registry;

import com.wecloud.dispatch.extend.ArgumentDefaultValueBuilder;
import com.wecloud.dispatch.extend.impl.DefaultArgumentDefaultValueBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lixiaozhong
 */
public class ArgumentDefaultValueBuilderRegistry {

	List<ArgumentDefaultValueBuilder> list = new ArrayList<>();

	ArgumentDefaultValueBuilder b = new DefaultArgumentDefaultValueBuilder();

	public void add(ArgumentDefaultValueBuilder builder) {
		list.add(builder);
	}

	public Object getValue(Class<?> type) {
		Object o = null;
		for (ArgumentDefaultValueBuilder ab : list) {
			o = ab.build(type);
			if (null != o) {
				return o;
			}
		}
		o = b.build(type);
		return o;
	}
}
