package com.jumeirah.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * <pre>
 * 优惠行程表 查询结果对象
 * </pre>
 *
 * @author xxx
 * @date 2020-10-14
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "StrokeDiscountQueryVo对象")
public class StrokeDiscountQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @ApiModelProperty("出发城市名称")
    private String cityOutsetName;

    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @ApiModelProperty("到达城市名称")
    private String cityArriveName;

    @ApiModelProperty("座位数")
    private Integer seatMun;

    @ApiModelProperty("飞机型号ID")
    private Long plainTypeId;

    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

    @ApiModelProperty("返程时间")
    private Timestamp returnTime;

    @ApiModelProperty("状态，0-正常，1-完成，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间")
    private Timestamp createTime;

    @ApiModelProperty("更新时间")
    private Timestamp updateTime;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("价格")
    private BigDecimal money;

    @ApiModelProperty("商家ID")
    private Long mcId;
}
