package com.wecloud.im.thousandchat.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.param.ImInboxPageParam;
import com.wecloud.im.param.ImInboxQueryVo;
import com.wecloud.im.thousandchat.entity.ImMsgReadLastest;
import com.wecloud.im.thousandchat.param.ConversationLastestReadMsg;
import com.wecloud.im.thousandchat.param.ThousandOffineMsgDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * @author lixiaozhong
 * 主要针对万人群的消息状态处理dao类
 */
@Repository
public interface ImMsgReadLastestMapper extends BaseMapper<ImMsgReadLastest> {

    /**
     * 获取分页对象
     *
     * @param page
     * @param imInboxPageParam
     * @return
     */
    IPage<ImInboxQueryVo> getImInboxPageList(@Param("page") Page page, @Param("param") ImInboxPageParam imInboxPageParam);


    /**
     * 万人群的消息已送达的插入/更新
     * @param lastestRead
     * @return
     */
    Long upsertImMsgReceive(ImMsgReadLastest lastestRead);

    /**
     * 万人群消息已读的插入/更新
     * @param lastestRead
     * @return
     */
    Long upsertImMsgRead(ImMsgReadLastest lastestRead);

    /**
     * 查找最新的已读记录，如果查回来是空，表示会话消息全未读
     * @param clientId
     * @return
     */
    List<ConversationLastestReadMsg> findLastestReadMsgs(@Param("clientId") Long clientId);

    /**
     * 查找万人群的离线消息
     * @param allConversationOfLastestReadMsgs
     */
    List<ThousandOffineMsgDto> findOfflineMsgs(@Param("lastestMsgs") List<ConversationLastestReadMsg> allConversationOfLastestReadMsgs);
}
