package com.wecloud.im.friend.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @author nanqianhao
 * @date 2022/9/21
 * @apiNote 加好友场景
 */
public enum AddFriendSceneEnum implements BaseEnum {
    // 陌生人
    STRANGER(1, "陌生人"),
    // 搜索
    SEARCH(2, "搜索"),
    // 名片
    CARD(3, "名片"),
    // 二维码
    QR_CODE(4, "二维码"),
    // 群聊
    GROUP_CHAT(5, "群聊");

    AddFriendSceneEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
