package com.jumeirah.common.service.impl;

import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.mapper.StrokeMapper;
import com.jumeirah.common.service.StrokeService;
import com.jumeirah.common.param.StrokePageParam;
import com.jumeirah.common.vo.StrokeQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 行程表 服务实现类
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@Service
public class StrokeServiceImpl extends BaseServiceImpl<StrokeMapper, Stroke> implements StrokeService {

    @Autowired
    private StrokeMapper strokeMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveStroke(Stroke stroke) throws Exception {
        return super.save(stroke);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateStroke(Stroke stroke) throws Exception {
        return super.updateById(stroke);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteStroke(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public StrokeQueryVo getStrokeById(Long id) throws Exception {
        return strokeMapper.getStrokeById(id);
    }

    @Override
    public Paging<StrokeQueryVo> getStrokePageList(StrokePageParam strokePageParam) throws Exception {
        Page<StrokeQueryVo> page = new PageInfo<>(strokePageParam, OrderItem.desc(getLambdaColumn(Stroke::getCreateTime)));
        IPage<StrokeQueryVo> iPage = strokeMapper.getStrokePageList(page, strokePageParam);
        return new Paging<StrokeQueryVo>(iPage);
    }

}
