package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImMultiRtcRoomMember;
import com.wecloud.im.mapper.ImMultiRtcRoomMemberMapper;
import com.wecloud.im.service.ImMultiRtcRoomMemberService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author wenzhida
 * @Date 2022/3/16 9:27
 * @Description 多人音视频房间成员服务接口实现
 */
@Slf4j
@Service
public class ImMultiRtcRoomMemberServiceImpl extends BaseServiceImpl<ImMultiRtcRoomMemberMapper, ImMultiRtcRoomMember> implements ImMultiRtcRoomMemberService {

    @Autowired
    private ImMultiRtcRoomMemberMapper imMultiRtcRoomMemberMapper;

    @Override
    public void changeRoomMemberState(Long fkClientId, String roomId, Integer state) {
        this.update(new UpdateWrapper<ImMultiRtcRoomMember>().lambda()
                .eq(ImMultiRtcRoomMember::getRoomId, roomId)
                .eq(ImMultiRtcRoomMember::getFkClientId, fkClientId)
                .set(ImMultiRtcRoomMember::getState, state));
    }
}
