package com.wecloud.im.controller;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.param.AgreeToMultiMeetParam;
import com.wecloud.im.param.HeartbeatMultiMeetParam;
import com.wecloud.im.param.InviteToMultiMeetParam;
import com.wecloud.im.param.LeaveFromMultiMeetParam;
import com.wecloud.im.param.NotAnsweredMultiMeetParam;
import com.wecloud.im.param.RejectToMultiMeetParam;
import com.wecloud.multimeet.service.MultiMeetService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author wenzhida
 * @Date 2022/3/7 18:08
 * @Description 多人音视频通话控制器
 */
@Slf4j
@RestController
@RequestMapping("/multiMeet")
@Api(value = "多人音视频通话", tags = {"多人音视频通话"})
public class ImMultiMeetController extends BaseController {

    @Autowired
    private MultiMeetService multiMeetService;

    /**
     * 邀请客户端加入
     */
    @PostMapping("/invite")
    @ApiOperation(value = "邀请加入多人音视频会议", notes = "邀请加入多人音视频会议")
    public ApiResult<Boolean> invite(@Validated @RequestBody InviteToMultiMeetParam param) {
        log.info("邀请加入多人音视频会议入参 {}", JSON.toJSONString(param));
        if (CollectionUtils.isEmpty(param.getToClients())) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        multiMeetService.invite(param);
        return ApiResult.ok();
    }

    @PostMapping("/reject")
    @ApiOperation(value = "拒接进入会议", notes = "拒接进入会议")
    public ApiResult<Boolean> reject(@RequestBody RejectToMultiMeetParam param) {
        log.info("拒绝加入多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.reject(param);
        return ApiResult.ok();
    }

    @PostMapping("/agree")
    @ApiOperation(value = "同意进入会议", notes = "同意进入会议")
    public ApiResult<Boolean> agree(@RequestBody AgreeToMultiMeetParam param) {
        log.info("同意进入多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.agree(param);
        return ApiResult.ok();
    }

    @PostMapping("/leave")
    @ApiOperation(value = "主动挂断(离开会议)", notes = "主动挂断(离开会议)")
    public ApiResult<Boolean> leave(@RequestBody LeaveFromMultiMeetParam param) {
        log.info("主动挂断多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.leave(param);
        return ApiResult.ok();
    }

    @PostMapping("/notAnswered")
    @ApiOperation(value = "未接听", notes = "未接听")
    public ApiResult<Boolean> notAnswered(@RequestBody NotAnsweredMultiMeetParam param) {
        log.info("多人音视频会议未接听入参 {}", JSON.toJSONString(param));
        multiMeetService.notAnswered(param);
        return ApiResult.ok();
    }

    @PostMapping("/heartbeat")
    @ApiOperation(value = "发送心跳", notes = "发送心跳")
    public ApiResult<Boolean> heartbeat(@RequestBody HeartbeatMultiMeetParam param) {
        multiMeetService.heartbeat(param);
        return ApiResult.ok();
    }

    @PostMapping("/isBeCalling")
    @ApiOperation(value = "是否正在被呼叫", notes = "是否正在被呼叫")
    public ApiResult<Boolean> isBeCalling() {
        multiMeetService.isBeCalling();
        return ApiResult.ok();
    }

}

