package com.jumeirah.common.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.geekidea.springbootplus.framework.core.validator.groups.Update;

/**
 * 优惠行程表
 *
 * @author xxx
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
    @EqualsAndHashCode(callSuper = true)
@ApiModel(value = "StrokeDiscount对象")
public class StrokeDiscount extends BaseEntity {
private static final long serialVersionUID=1L;

            @NotNull(message = "id不能为空", groups = {Update.class})
        @ApiModelProperty("主键ID")
                @TableId(value = "id", type = IdType.AUTO)
                private Long id;

            @NotNull(message = "出发城市id不能为空")
        @ApiModelProperty("出发城市id")
        private Long cityOutsetId;

            @NotBlank(message = "出发城市名称不能为空")
        @ApiModelProperty("出发城市名称")
        private String cityOutsetName;

            @NotNull(message = "到达城市id不能为空")
        @ApiModelProperty("到达城市id")
        private Long cityArriveId;

            @NotBlank(message = "到达城市名称不能为空")
        @ApiModelProperty("到达城市名称")
        private String cityArriveName;

            @NotNull(message = "座位数不能为空")
        @ApiModelProperty("座位数")
        private Integer seatMun;

            @NotNull(message = "飞机型号ID不能为空")
        @ApiModelProperty("飞机型号ID")
        private Long plainTypeId;

            @NotNull(message = "出发时间不能为空")
        @ApiModelProperty("出发时间")
        private Date outsetTime;

            @ApiModelProperty("返程时间")
        private Date returnTime;

            @NotNull(message = "状态，0-正常，1-完成，99-删除不能为空")
        @ApiModelProperty("状态，0-正常，1-完成，99-删除")
        private Integer status;

            @NotNull(message = "创建时间不能为空")
        @ApiModelProperty("创建时间")
        private Long createTime;

            @ApiModelProperty("更新时间")
        private Long updateTime;

            @ApiModelProperty("备注")
        private String remarks;

            @ApiModelProperty("价格，单位：分")
        private Long money;

            @NotNull(message = "商家ID不能为空")
        @ApiModelProperty("商家ID")
        private Long mcuId;

}
