package com.wecloud.im.controller;

import com.wecloud.im.param.ImTokenVerify;
import com.wecloud.im.service.ImClientLoginService;
import com.wecloud.im.vo.TokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * token 控制器
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@RestController
@RequestMapping("/token")
@Api(value = "token API", tags = {"token相关"})
public class TokenController extends BaseController {

    @Autowired
    private ImClientLoginService imClientLoginService;

    /**
     * 根据客户方生成签名字符串 验证通过则下发token
     */
    @PostMapping("/verify")
    @ApiOperation(value = "验证sign,并返回token", notes = "根据客户方生成签名字符串 验证通过则下发token")
    public ApiResult<TokenVo> verify(@RequestBody ImTokenVerify imTokenVerify) throws Exception {

        return imClientLoginService.verifySign(imTokenVerify);
    }


}

