package com.wecloud.im.service;

import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.param.add.ImConversationCreate;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 会话表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationService extends BaseService<ImConversation> {

    /**
     * 保存
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean saveImConversation(ImConversation imConversation) throws Exception;


    ApiResult<ImConversation> createImConversation(ImConversationCreate imConversationCreate);

    /**
     * 修改
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean updateImConversation(ImConversation imConversation) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImConversation(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImConversationQueryVo getImConversationById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imConversationPageParam
     * @return
     * @throws Exception
     */
    Paging<ImConversationQueryVo> getImConversationPageList(ImConversationPageParam imConversationPageParam) throws Exception;

}
