package com.wecloud.imserver.client.model.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author nanqianhao
 * @date 2022/6/9
 * @apiNote
 */
@Getter
@Setter
@ToString
public class RtcApplicationProductsConfigDTO implements Serializable {

    /**
     * 应用id
     */
    private Long fkAppid;

    /**
     * 语音通话时长/分钟
     */
    private Long voiceCallTimeRemain;

    /**
     * 视频通话HD时长/分钟
     */
    private Long videoCallTimeRemain;

    /**
     * 音频录制时长/分钟
     */
    private Long voiceRecordingTimeRemain;

    /**
     * 视频录制HD时长/分钟
     */
    private Long videoRecordingTimeRemain;

    /**
     * 语音通话到期时间
     */
    private LocalDateTime voiceCallExpireTime;

    /**
     * 视频通话到期时间
     */
    private LocalDateTime videoCallExpireTime;

    /**
     * 音频录制到期时间
     */
    private LocalDateTime voiceRecordingExpireTime;

    /**
     * 视频录制到期时间
     */
    private LocalDateTime videoRecordingExpireTime;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 更新人id
     */
    private Long updateBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
