package com.wecloud.imserver.client.api;

import com.wecloud.imserver.client.model.ao.ImOverviewAO;
import com.wecloud.imserver.client.model.ao.ImRtcOverviewAo;
import com.wecloud.imserver.client.model.dto.Result;
import com.wecloud.imserver.client.model.vo.LineChart;
import com.wecloud.imserver.client.model.vo.OverviewVo;
import com.wecloud.imserver.client.model.vo.RtcRecordVo;
import com.wecloud.imserver.client.model.vo.StatisticsVo;

import java.util.List;

/**
 * @author wxh
 */
public interface ImOverview {

    /**
     * 服务概览
     * @param appId
     * @return
     */
    Result<OverviewVo> overview(Long appId);

    /**
     * 数据统计中的业务统计
     * @param imOverviewAo
     * @return
     */
    Result<StatisticsVo> groupStatistics(ImOverviewAO imOverviewAo);

    /**
     * 用户统计折线图
     * @param imOverviewAo
     * @return
     */
    Result<List<LineChart>> activeUser(ImOverviewAO imOverviewAo);

    /**
     * 音视频资讯的数量统计
     * @param imrtcOverviewAo
     * @return
     */
    Result<RtcRecordVo> rtcStatistics(ImRtcOverviewAo imrtcOverviewAo);
}
