package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 会话表
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImConversation对象")
public class ImConversation extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "会话id不能为空")
    @ApiModelProperty("会话id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("对话中最后一条消息的发送或接收时间")
    private Date lastMessage;

    @ApiModelProperty("群成员数量")
    private Integer memberCount;

    @ApiModelProperty("会话属性，1：单聊，2：普通群，3：万人群")
    private Integer chatType;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @NotNull(message = "创建者客户端id不能为空")
    @ApiModelProperty("创建者客户端id")
    private Long creator;

    @ApiModelProperty("可选	 对话的名字，可为群组命名。")
    private String name;

    @ApiModelProperty("可选	自定义属性，供开发者扩展使用。")
    private String attributes;

    @ApiModelProperty("可选	对话类型标志，是否是系统对话，后面会说明。")
    private Boolean systemFlag;

}
