package com.wecloud.rtc.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.param.rtc.CandidateForwardParam;
import com.wecloud.im.param.rtc.CreateRtcChannelParam;
import com.wecloud.im.param.rtc.CreateRtcChannelResult;
import com.wecloud.im.param.rtc.JoinRtcChannelParam;
import com.wecloud.im.param.rtc.LeaveRtcChannelParam;
import com.wecloud.im.param.rtc.RejectRtcChannelParam;
import com.wecloud.im.param.rtc.SdpForwardParam;
import io.geekidea.springbootplus.framework.common.api.ApiResult;

/**
 * 管理rtc频道
 */
public interface RtcService {

    /**
     * 创建一个频道,并向接收方发送系统推送
     */
    ApiResult<CreateRtcChannelResult> createAndCall(CreateRtcChannelParam createRtcChannelParam);

    /**
     * 加入频道
     */
    ApiResult<Boolean> join(JoinRtcChannelParam joinRtcChannelParam);

    /**
     * 拒接加入频道
     */
    ApiResult<Boolean> reject(RejectRtcChannelParam rejectRtcChannelParam);

    /**
     * 退出频道
     */
    ApiResult<Boolean> leave(LeaveRtcChannelParam leaveRtcChannelParam);

    /**
     * SDP数据转发
     *
     * @param sdpForwardParam
     * @return
     */
    ApiResult<Boolean> sdpForward(SdpForwardParam sdpForwardParam);

    /**
     * candidate候选者数据转发
     *
     * @param candidateForwardParam
     * @return
     */
    ApiResult<Boolean> candidateForward(CandidateForwardParam candidateForwardParam);

}
