package com.wecloud.im.sdk;

import java.util.List;

import com.wecloud.im.sdk.model.Attributes;
import com.wecloud.im.sdk.model.Blacklist;
import com.wecloud.im.sdk.model.ChatRoomMember;
import com.wecloud.im.sdk.model.ClientRelation;
import com.wecloud.im.sdk.model.Conversation;
import com.wecloud.im.sdk.model.Friend;
import com.wecloud.im.sdk.model.GroupChatMessage;
import com.wecloud.im.sdk.model.GroupChatStatusMessage;
import com.wecloud.im.sdk.model.GroupSettingParam;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.ImRtcRecord;
import com.wecloud.im.sdk.model.PageResult;
import com.wecloud.im.sdk.model.PrivateChatMessage;
import com.wecloud.im.sdk.model.PrivateChatStatusMessage;
import com.wecloud.im.sdk.model.RtcRecord;
import com.wecloud.im.sdk.model.SingleUserNotification;
import com.wecloud.im.sdk.model.Token;
import com.wecloud.im.sdk.model.UnsureFriend;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:09
 * @Version 1.0
 */
public interface WecloudIm {

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 04:25:52
     * @param userId 用户id
     * @param headPortrait 头像
     * @param nickname 昵称
     * @Return
     */
    ImClient registerUser(String userId, String headPortrait, String nickname);

    /**
     * 获取用户token
     * @Author luozh
     * @Date 2022年04月18日 11:50:44
     * @param userId 用户id
     * @param deviceType 设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac
     * @Return
     */
    Token getToken(String userId, Integer deviceType);


    /**
     * 修改用户
     * @Author luozh
     * @Date 2022年04月18日 03:29:52
     * @param userId 用户id
     * @param nickname 昵称
     * @param headPortrait 头像
     * @Return
     */
    Boolean modifyUser(String userId, String nickname, String headPortrait);

    /**
     * 获取用户拓展信息
     * @Author luozh
     * @Date 2022年04月18日 03:29:52
     * @param userId 用户id
     * @Return
     */
    Attributes getUserAttributes(String userId);

    /**
     * 更新用户拓展信息
     * @Author luozh
     * @Date 2022年04月18日 03:29:52
     * @param userId 用户id
     * @param attributes 用户拓展字段
     * @Return
     */
    Boolean modifyUserAttributes(String userId, Attributes attributes);

    /**
     * 封禁用户
     * @Author luozh
     * @Date 2022年05月16日 02:57:55
     * @param userId 用户id
     * @param minute 封禁时长，单位为分钟，最大值为 43200 分钟。
     * @Return
     */
    Boolean bannedUser(String userId, Integer minute);

    /**
     * 获取好友请求列表
     * @Author luozh
     * @Date 2022年04月21日 04:50:57
     * @param userId 用户id
     * @Return
     */
    List<UnsureFriend> getUnsureFriends(String userId);

    /**
     * 获取所有好友列表
     * @Author luozh
     * @Date 2022年04月22日 11:45:15
     * @param userId 用户id
     * @Return
     */
    List<Friend> getFriends(String userId);

    /**
     * 好友申请
     * @Author luozh
     * @Date 2022年04月28日 02:05:11
     * @param userId 用户id
     * @param friendId 好友id
     * @param friendName 备注好友名称
     * @param requestRemark 请求备注
     * @Return
     */
    Boolean friendRequest(String userId, String friendId, String friendName, String requestRemark);

    /**
     * 删除好友
     * @Author luozh
     * @Date 2022年05月16日 10:14:07
     * @param userId
     * @param friendUserIds
     * @Return
     */
    Boolean unfriend(String userId, String friendUserIds);

    /**
     * 备注好友
     * @Author luozh
     * @Date 2022年05月16日 11:13:35
     * @param userId
     * @param friendUserId
     * @param remark
     * @Return
     */
    Boolean remarkFriend(String userId, String friendUserId, String remark);

    /**
     * 用户好友关系
     * @Author luozh
     * @Date 2022年05月13日 10:58:28
     * @param
     * @Return
     */
    ClientRelation userRelation(String userId, String friendId);

    /**
     * 用户与多个好友关系
     * @Author luozh
     * @Date 2022年05月13日 10:58:28
     * @param
     * @Return
     */
    List<ClientRelation> usersRelation(String userId, String friendIds);

    /**
     * 获取黑名单列表
     * @Author luozh
     * @Date 2022年05月07日 05:23:40
     * @param userId
     * @Return
     * @return
     */
    PageResult<Blacklist> pageBlacklist(Integer pageIndex, Integer pageSize, String userId);

    /**
     * 设置会话置顶
     * @Author luozh
     * @Date 2022年04月26日 03:33:44
     * @param userId 用户id
     * @param conversationId 会话id
     * @param top 是否置
     * @Return
     */
    Boolean setConversationTop(String userId, Long conversationId, Boolean top);

    /**
     * 设置会话免打扰
     * @Author luozh
     * @Date 2022年04月26日 03:33:44
     * @param userId 用户id
     * @param conversationId 会话id
     * @param doNotDisturb 是否免打扰
     * @Return
     */
    Boolean setConversationDoNotDisturb(String userId, Long conversationId, Boolean doNotDisturb);

    /**
     * 群成员好友申请
     * @Author luozh
     * @Date 2022年04月28日 02:06:01
     * @param
     * @Return
     */
    Boolean groupMembersFriendRequest(Long conversationId, String userId, String friendId, String friendName,
                                      String requestRemark);

    /**
     * 全量获取聊天室成员
     * @param chatRoomId 聊天室id
     * @return
     */
    List<ChatRoomMember> listChatRoomMember(Long chatRoomId);

    /**
     * 批量获取会话信息
     * @param chatType 会话属性，1：单聊，2：普通群，3：万人群，4：聊天室
     * @param conversationIds
     * @return
     */
    List<Conversation> listConversation(Integer chatType, List<Long> conversationIds);

    /**
     * 发布群聊消息
     * @Author luozh
     * @Date 2022年05月05日 09:38:34
     * @param groupChatMessage 发布群聊消息参数
     * @Return
     */
    Boolean publishGroupChatMessage(GroupChatMessage groupChatMessage);

    /**
     * 发布群聊状态消息
     * @Author luozh
     * @Date 2022年05月05日 09:38:34
     * @param groupChatStatusMessage 发布群聊消息参数
     * @Return
     */
    Boolean publishGroupChatStatusMessage(GroupChatStatusMessage groupChatStatusMessage);

    /**
     * 发布单聊消息
     * @Author luozh
     * @Date 2022年05月05日 09:38:34
     * @param privateChatMessage 发布单聊消息参数
     * @Return
     */
    Boolean publishPrivateMessage(PrivateChatMessage privateChatMessage);

    /**
     * 发布群聊状态消息
     * @Author luozh
     * @Date 2022年05月05日 09:38:34
     * @param privateChatStatusMessage 发布群聊消息参数
     * @Return
     */
    Boolean publishPrivateStatusMessage(PrivateChatStatusMessage privateChatStatusMessage);

    /**
     * 创建群组
     * @Author luozh
     * @Date 2022年05月09日 06:34:58
     * @param userId 用户id
     * @param groupName 用户名称
     * @param memberIds 群成员
     * @Return 创建结果 true/false
     */
    Long createGroup(String groupOwnerUserId, String groupName, String memberIds);

    /**
     * 解散群组(非群组创建者也可以解散群组)
     * @Author luozh
     * @Date 2022年05月09日 06:42:18
     * @param userId 用户id
     * @param groupId 群组id
     * @Return 解散结果 true/false
     */
    Boolean dismissGroup(String userId, String groupId);

    /**
     * 加入群组
     * @Author luozh
     * @Date 2022年05月09日 06:43:07
     * @param groupId 要加入的群id
     * @param userIds 要加入群的用户id
     * @Return 加入结果 true/false
     */
    Integer joinGroup(String inviterUserId, String groupId, String userIds);

    /**
     * 离开群组
     * @Author luozh
     * @Date 2022年05月09日 06:43:07
     * @param groupId 要离开的群id
     * @param userIds 要离开群的用户id
     * @Return 加入结果 true/false
     */
    Integer leaveGroup(String operatorUserId, String groupId, String userIds);

    /**
     * 获取群成员列表
     * @Author luozh
     * @Date 2022年05月09日 06:46:10
     * @param groupId 群组id
     * @Return 群成员id
     */
    List<String> listGroupMembers(String groupId);

    /**
     * 群设置
     * @param param 群设置入参
     * @return 设置结果
     */
    Boolean groupSetting(GroupSettingParam param);

    /**
     * 禁言群成员
     * @Author luozh
     * @Date 2022年05月16日 07:27:52
     * @param groupId 群组id
     * @param muted 禁言/解禁对应true/false
     * @param userIds 用户id列表
     * @Return
     */
    Boolean mutedGroupMember(String groupId, Boolean muted, String userIds);

    /**
     * 更换群主
     * @Author luozh
     * @Date 2022年05月17日 04:12:33
     * @param groupId 群组id
     * @param newGroupOwnerUserId 新群主用户id
     * @Return
     */
    Boolean groupOwnerTransfer(String groupId, String newGroupOwnerUserId);

    /**
     * 增加群管理员
     * @Author luozh
     * @Date 2022年05月17日 06:02:04
     * @param groupId
     * @param adminUserIds
     * @Return
     */
    Boolean addGroupAdmin(String groupId, String adminUserIds);

    /**
     * 移除群管理员
     * @param groupId
     * @param adminUserIds
     * @return
     */
    Boolean removeGroupAdmin(String groupId, String adminUserIds);

    /**
     * 获取通话记录列表
     * @Author nanqianhao
     * @Date 2022年05月23日 11:30
     */
    PageResult<ImRtcRecord> getPageImRtcRecords(RtcRecord rtcRecord);

    /**
     * 单个用户通知
     * @Author luozh
     * @Date 2022年05月25日 09:36:47
     * @param
     * @Return
     */
    Boolean singleUserNotification(SingleUserNotification singleUserNotification);
}
