-- 在feature-cluster 2021年12月22日之后，需要执行的的sql增量脚本
ALTER TABLE `im_conversation` CHANGE COLUMN `system` `system_flag` tinyint(1) NULL DEFAULT NULL COMMENT '可选	对话类型标志，是否是系统对话，后面会说明。' AFTER `attributes`;
ALTER TABLE `im_message` CHANGE COLUMN `system` `system_flag` tinyint(1) NULL DEFAULT 0 COMMENT '0非系统通知; 1为系统通知' AFTER `event`;
-- 在feature-cluster 2022年1月4日之后，需要执行的sql增量脚本
ALTER TABLE im_conversation
    ADD COLUMN`member_count` int NULL COMMENT '群成员数' AFTER`last_message`;

ALTER TABLE im_conversation
    ADD COLUMN`chat_type` tinyint NULL COMMENT '是否万人群' AFTER`member_count`;

ALTER TABLE `im_conversation_members`
    ADD INDEX `fk_client_id`(`fk_client_id`);

-- 在feature-cluster 2022年1月10日之后，需要执行的sql增量脚本
-- 消息最新已读寻址表
CREATE TABLE `im_msg_read_lastest`
(
    `id`                 bigint NOT NULL COMMENT '收件id',
    `create_time`        timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`        timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `read_time`          timestamp NULL DEFAULT NULL COMMENT '读取时间',
    `receive_time`       timestamp NULL DEFAULT NULL COMMENT '接收时间',
    `fk_appid`           bigint NOT NULL COMMENT '应用appid',
    `fk_client_id`       bigint NOT NULL COMMENT '接收客户端id',
    `fk_conversation_id` bigint NOT NULL COMMENT '会话id',
    `fk_receive_msg_id`  bigint DEFAULT NULL COMMENT '最后一条已接收的消息id',
    `fk_read_msg_id`     bigint DEFAULT NULL COMMENT '最后一条已读的消息id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `receiver_conversation`(`fk_client_id`,`fk_conversation_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='消息最新已读寻址表';


CREATE TABLE `im_friend`
(
    `id`                   bigint  NOT NULL COMMENT '主键id',
    `fk_client_id`         bigint  NOT NULL COMMENT '自己id',
    `fk_client_id_friend`  bigint  NOT NULL COMMENT '好友id',
    `fk_client_id_claimer` bigint  NOT NULL COMMENT '好友申请者',
    `friend_name`          varchar(255)     DEFAULT NULL COMMENT '好友名称备注',
    `reject_remark`        varchar(255)     DEFAULT NULL COMMENT '拒绝说明',
    `request_remark`       varchar(255)     DEFAULT NULL COMMENT '好友请求说明',
    `state`                tinyint NOT NULL DEFAULT '0' COMMENT '好友状态，1：待确定，2：已确认，3：已拒绝，4：已删除',
    `create_time`          timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`          timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `friend_id`(`fk_client_id`,`fk_client_id_friend`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='好友表';

CREATE TABLE `im_friend_recommend`
(
    `id`                  bigint(20) NOT NULL COMMENT '主键id',
    `fk_client_id`        bigint(20) NOT NULL COMMENT '自己id',
    `fk_client_id_friend` bigint(20) NOT NULL COMMENT '好友id',
    `source`              tinyint         DEFAULT NULL COMMENT '推荐来源',
    `del_flag`            bit(1) NOT NULL default 0 COMMENT '删除标识',
    `create_time`         timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`         timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `friend_id`(fk_client_id, fk_client_id_friend) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='好友表';


-- 2022年01月21日17:31:16  何威 将type参数上移一层
ALTER TABLE `im_message`
    ADD COLUMN`msg_type` int(2) NULL DEFAULT NULL COMMENT '消息类型' AFTER`send_status`;

ALTER TABLE im_message ADD COLUMN is_delete tinyint NOT NULL DEFAULT '1' COMMENT '是否删除 1-未删除 2-删除';

ALTER TABLE im_conversation_members ADD COLUMN role tinyint NOT NULL DEFAULT '1' COMMENT '角色 1-普通群成员 2-管理员 3-群主';