package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.param.ApiImConversationMembersQueryVo;
import com.wecloud.im.param.ImConversationMembersPageParam;
import com.wecloud.im.param.ImConversationMembersQueryVo;
import com.wecloud.im.param.SetAdminsParam;
import com.wecloud.im.vo.ImConversationMemberListVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * 会话成员表 Mapper 接口
 *
 * @author wei
 * @since 2021-05-07
 */
@Repository
public interface ImConversationMembersMapper extends BaseMapper<ImConversationMembers> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImConversationMembersQueryVo getImConversationMembersById(Serializable id);


    List<ApiImConversationMembersQueryVo> getRestApiImConversationMembersList(@Param("conversationId") Long conversationId);

    List<ImConversationMemberListVo> getImConversationMembersList(@Param("conversationId") Long conversationId);


    /**
     * 获取分页对象
     *
     * @param page
     * @param imConversationMembersPageParam
     * @return
     */
    IPage<ImConversationMembersQueryVo> getImConversationMembersPageList(@Param("page") Page page, @Param("param") ImConversationMembersPageParam imConversationMembersPageParam);

    List<Long> findThousandGroupsByClientId(@Param("clientId") Long clientId);

    /**
     * 批量设置群成员
     * @param param
     * @return
     */
    void setAdminsForConversation(@Param("param") SetAdminsParam param);
}
