package com.jumeirah.api.merchant.controller;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * Hello World Controller
 **/
@Slf4j
@Api(value = "Hello World2", tags = {"商户Hello World2"})
@RestController
@RequestMapping("/merchant/")
public class MerchantHelloWorldController {

    @GetMapping(value = "/world")
    @OperationLog(name = "helloWorld")
    @ApiOperation(value = "Hello World", response = String.class)
    public ApiResult<String> helloWorld() throws IOException {
        log.debug("Hello World...app");
        return ApiResult.ok("Hello World app merchant");
    }

    @GetMapping(value = "/needRole")
    @OperationLog(name = "needRole")
    @ApiOperation(value = "needRole", response = String.class)
    public ApiResult<String> needRole() throws IOException {
        log.debug("Hello World...app");
        return ApiResult.ok("Hello World app");
    }

    @GetMapping(value = "/needRoleAdmin")
    @OperationLog(name = "needRoleAdmin")
    @ApiOperation(value = "needRoleAdmin", response = String.class)
    @RequiresPermissions("mer:admin")
    public ApiResult<String> needRoleAdmin() throws IOException {
        log.debug("Hello World...app");
        return ApiResult.ok("Hello World needRoleAdmin");
    }

    @GetMapping(value = "/needRoleAll")
    @OperationLog(name = "needRoleAll")
    @ApiOperation(value = "needRoleAll", response = String.class)
    @RequiresRoles("app:all")
    public ApiResult<String> needRoleAll() throws IOException {
        log.debug("Hello World...app");
        return ApiResult.ok("Hello World needRoleAll");
    }

    @GetMapping(value = "/noRole")
    @OperationLog(name = "noRole")
    @ApiOperation(value = "noRole", response = String.class)
    public ApiResult<String> noRole() throws IOException {
        log.debug("Hello World...app");
        return ApiResult.ok("Hello World app noRole");
    }

}
